
if __PURE__Clouds__method == 1 and ac.getPatchVersionCode() < 1992 then
    -- Skydomes need CSP 0.178 or higher
    __PURE__Clouds__method = 0
    __PURE__reset_config("clouds_render.method", __PURE__Clouds__method)
end
if __PURE__Clouds__method == 2 and ac.getPatchVersionCode() < 2234 then
    -- Raymarching clouds need CSP 0.180 or higher
    __PURE__Clouds__method = 0
    __PURE__reset_config("clouds_render.method", __PURE__Clouds__method)
end


if __PURE__Clouds__method < 2 then
    if __PURE__Clouds__method > 0 then
        dofile (__pure__path.."\\world\\clouds\\2d\\clouds_main.lua")
    end
    --if __PURE__Clouds__method < 1 or __PURE_use_3d_cloud_shadows then
    dofile (__pure__path.."\\world\\clouds\\3d\\clouds_main.lua")
    --end
elseif __PURE__Clouds__method == 2 then
    dofile (__pure__path.."\\world\\clouds\\3d_raymarching\\clouds_main.lua")
end


function clouds__get_cloud_coverage()
    if not __ECO__ then
        if __PURE__Clouds__method == 0 then
            return clouds__3D__get_cloud_coverage()
        elseif __PURE__Clouds__method == 1 then
            return PURE__2DCLOUDS_get_cloud_coverage()
        else
            return 0
        end
    else
        return __PURE__overcast
    end
end

function clouds__get_sun_cover()

    if not __ECO__ then
        if __PURE__Clouds__method == 0 then
            return __PURE__Clouds_shadow
        elseif __PURE__Clouds__method == 1 then
            return __PURE__Clouds_shadow__SkyCover
        else
            return 0
        end
    else
        return __PURE__overcast
    end
end

function __PURE__update_clouds(dt)

    if __CSP_version > 3629 then
        ac.setCloudShadowBlur(__PURE__get_config("clouds_render.shadows_blur"))
    end

    if not __ECO__ then
        if __PURE__Clouds__method < 2 then
            if __PURE__Clouds__method > 0 and clouds_2d_update~=nil then
                clouds_2d_update(dt)
            end
            --if __PURE__Clouds__method < 1 or __PURE_use_3d_cloud_shadows then
                clouds_3d_update(dt)
            --end
        else
            clouds_3d_raymarching_update(dt)
        end

        Pure__world__update_lightnings(dt)
    else
        if not __PURE_use_3d_cloud_shadows then
            __PURE__Clouds_shadow__2d_global_shadow = 1-__PURE__overcast
        else
            __PURE__Clouds_shadow__2d_global_shadow = 1
        end
    end
end

function __PURE__async_update_clouds(dt)

    if not __ECO__ then
        if __PURE__Clouds__method < 2 then
            if __PURE__Clouds__method > 0 and clouds_2d_async_update~=nil then
                clouds_2d_async_update(dt)
            end
            --if __PURE__Clouds__method < 1 or __PURE_use_3d_cloud_shadows then
                clouds_3d_async_update(dt)
            --end
        else
            clouds_3d_raymarching_async_update(dt)
        end
    end
end